qui {
set output error

noi {
	/**********************************************************************/
	/****** Step 2.2. Simulate counterfactuals - Robustness check 2 *******/
	/**********************************************************************/
}


* Identify metropolitan states
cd ..
cd ".\4. Master data"
use master_data, clear
levelsof mother_cntry if year > $startyear & mother_cntry != cntry & independence_years < 0 & independence_years != ., local(metropolitan_states)

cd ..
cd "./3. Intermediary results"

* 6.2.3. Run algorithm
local count = 0
foreach NIC in $NICs {
	
	local count = `count'+1
	noisily di "Synthetic control method: newly independent cntry `count'/$max [" c(current_date) " : " c(current_time) "]:"

		
	* Clean data (remove incomplete simulations)
	cd ".\3.1. Simulated gaps\3.1.1.3. Robustness check 2\3.1.1.1. Weights"
	cap confirm file cntry_weights1_`NIC'.dta
	if _rc != 0 {
		cd .. 
		cd ..
		cd ..
		cd ".\3.2. Individual pseudo-gaps\3.2.3. Robustness check 2\3.2.2. Intermediaries"
		capture erase placebo1_`NIC'.dta
		}
	cd ..
	cd ..
	cd ..
		
	* Check which cases still needed to be simulated
	cd ".\3.2. Individual pseudo-gaps\3.2.3. Robustness check 2\3.2.2. Intermediaries"
	capture confirm file placebo1_`NIC'.dta
	cd ..
	cd ..
	cd ..
	if _rc != 0 {
	
		cd ".\3.4. Intermediaries"
		
		local identifier = "_10_"
		use data_10_`NIC', clear
									
		* Drop countries outside time constraint
		sum independence_year
		local independence_year = `r(mean)'
		levelsof cntrycode if cntrycode != `NIC', local(countries)
		foreach cntry in `countries' {
			sum independence_years if year == `independence_year' & cntrycode == `cntry'
			cap drop if cntrycode == `cntry' & `r(mean)' < ${time_constraint}
			}
		
		* Drop metropolitan states
		foreach cntry in `metropolitan_states' {
			drop if cntry == "`cntry'"
			}
			
		cd ..
		cd ..
		
		* Gather MSPE info
		preserve 
		keep earliest_* last_* preind* independence_year
		ds
		restore
		
		foreach input in `r(varlist)' {
			sum `input'
			local `input' = `r(mean)'
			}
			
		* Check data availability of covariates
		global SCM_covariates_1
		foreach var in $SCM_covariates {
			if "`var'" != "baseline_gdpcap" {
			cap sum earliest_year_`var'
				if _rc == 0 {
					if `earliest_year_`var'' <= `preindependence_year_1' {
						global SCM_covariates_1 $SCM_covariates_1 `var'(`earliest_year_`var''/`preindependence_year_1')
						}
					}
				}
			}
			
		* Perform simulation for this NIC
		cap noi synth baseline_gdpcap baseline_gdpcap(`earliest_year_baseline_gdpcap'(1)`preindependence_year_1') $SCM_covariates_1 , mspeperiod(`earliest_year_baseline_gdpcap'/`preindependence_year_1') resultsperiod(`earliest_year'/`last_year') trunit(`NIC') trperiod(`independence_year') nested allopt
		if _rc != 0 {
				*If no convergence is reached: apply the second-most accurate (nested) approach
			cap synth baseline_gdpcap baseline_gdpcap(`earliest_year_baseline_gdpcap'(1)`preindependence_year_1') $SCM_covariates_1 , mspeperiod(`earliest_year_baseline_gdpcap'/`preindependence_year_1') resultsperiod(`earliest_year'/`last_year') trunit(`NIC') trperiod(`independence_year') nested
			if _rc != 0 {
				*If no convergence is reached: use the third-most accurate (regression-based) approach
				cap synth baseline_gdpcap baseline_gdpcap(`earliest_year_baseline_gdpcap'(1)`preindependence_year_1') $SCM_covariates_1 , mspeperiod(`earliest_year_baseline_gdpcap'/`preindependence_year_1') resultsperiod(`earliest_year'/`last_year') trunit(`NIC') trperiod(`independence_year')
				}
			}
		else if _rc == 0 {
			matrix cntry_weights = e(W_weights)
			local check_weights = cntry_weights[1,2]
			if `check_weights' == . {
				noi di "missing weights, re-estimate"
					cap synth baseline_gdpcap baseline_gdpcap(`earliest_year_baseline_gdpcap'(1)`preindependence_year_1') $SCM_covariates_1 , mspeperiod(`earliest_year_baseline_gdpcap'/`preindependence_year_1') resultsperiod(`earliest_year'/`last_year') trunit(`NIC') trperiod(`independence_year') nested
					}
				}
						
		* Save results matrices
						
			* weights
			matrix cntry_weights1_`NIC' = e(W_weights)
			matsave cntry_weights1_`NIC', replace p(".\3. Intermediary results\3.1. Simulated gaps\3.1.1.3. robustness check 2\3.1.1.1. Weights") saving
			
			* balance
			matrix balance1_`NIC' =  e(X_balance)
			matsave balance1_`NIC', replace  p(".\3. Intermediary results\3.1. Simulated gaps\3.1.1.3. robustness check 2\3.1.1.2. Balance") saving
						
		* Perform placebo-simulations for control group
		scalar numberofcontrols = rowsof(cntry_weights1_`NIC')
		local numberofcontrols = numberofcontrols
		global looprange = `numberofcontrols'
		noisily di "# Placebo gaps to estimate = `numberofcontrols'", _continue
		
		* Parallel simulation procedure
		
			* Clean data (remove incomplete simulations)

			cd ".\3. Intermediary results\3.2. Individual pseudo-gaps\3.2.3. robustness check 3\3.2.2. Intermediaries"
			forval j= 1 /`numberofcontrols' {

				* Check whether the simulation was initiated
				capture confirm file controle1_`NIC'_`j'.dta
				if _rc == 0 {	
					
					* If so: check whether it was finished
					cd ..
					cd ".\3.2.1. Weights"
					capture confirm file cntry_weights1_`NIC'_`j'.dta
					if _rc != 0 {	
						
						cd ..
						cd ".\3.2.2. Intermediaries"
						* If not: remove indicator and loop over it again
						erase controle1_`NIC'_`j'.dta
						}
						
					}
					
				}
			cd ..
			cd ..
			cd ..
			cd ..
			
			* Save data for usage in parallel computation procedure
			cd "./3. Intermediary results"
			gen str identifier = "`identifier'"
			gen specification = 1
			gen NIC = `NIC'
			gen looprange = `numberofcontrols'
			save data, replace
			clear all
			
			* Run computations						
			cd ..
			cd ".\1. Dofiles"
			parallel setclusters $numberofclusters, force
			noi parallel do "2.2.f. Parallel loop.do", nodata
			noisily di ": done"
			noisily di ""
			
			* Erase unnecessary information
			cd ..
			cd "./3. Intermediary results"
			use data, clear
			erase data.dta
									
			* Indicate everything is estimated
			cd ".\3.2. Individual pseudo-gaps\3.2.3. robustness check 2\3.2.1. Weights"
			cap confirm file cntry_weights1_`NIC'_`numberofcontrols'.dta
			if _rc == 0 {
				cd ..
				cd ".\3.2.2. Intermediaries"
				gen n = _n
				keep if n == 1
				keep n
				save placebo1_`NIC', replace
				cd ..
				cd ..
				cd ..
				}
			else if _rc != 0 {
				cd ..
				cd ..
				cd ..
				}
			}
		}

* Reroute to directory containing dofiles
cd ..
cd ".\1. Dofiles"
}
